/*
 * BaseShapes_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef BASESHAPES_IMPL_HPP_
#define BASESHAPES_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


class Vector;
class LineSegmentSet;

#include "Shapes/Shape_impl.hpp"
#include "Shapes/ShapeExceptions.hpp"
#include "Shapes/ShapeType.hpp"

class Sphere_impl : public Shape_impl {
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString() const;
  virtual enum ShapeType getType() const;
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
};

class Cuboid_impl : public Shape_impl {
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString() const;
  virtual enum ShapeType getType() const;
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
};

#endif /* BASESHAPES_IMPL_HPP_ */
