/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeFormulaDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "MoleculeFormulaDescriptor.hpp"
#include "MoleculeFormulaDescriptor_impl.hpp"

#include "Formula.hpp"
#include "molecule.hpp"


MoleculeFormulaDescriptor_impl::MoleculeFormulaDescriptor_impl(const Formula &_formula) :
  formula(_formula)
{}

MoleculeFormulaDescriptor_impl::~MoleculeFormulaDescriptor_impl(){}

bool MoleculeFormulaDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule){
  return molecule.second->getFormula() == formula;
}


MoleculeDescriptor MoleculeByFormula(const Formula &formula)
{
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeFormulaDescriptor_impl(formula)));
}

MoleculeDescriptor MoleculeByFormula(const std::string &_formula) throw(FormulaStringParseException){
  Formula formula(_formula);
  return MoleculeByFormula(formula);
}
