/*
 * FragmentResult.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTRESULT_HPP_
#define FRAGMENTRESULT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include "types.hpp"

/** This class contains the result to a specific FragmentJob.
 *
 */
class FragmentResult
{
public:
  FragmentResult(const JobId_t id);
  FragmentResult(const FragmentResult &other);
  ~FragmentResult();

  FragmentResult& operator=(const FragmentResult &other);
  bool operator==(const FragmentResult &other) const;
  bool operator!=(const FragmentResult &other) const
    { return !(*this == other); }


  //!> this job's unique id
  const JobId_t id;
  //!> result
  std::string result;
};


#endif /* FRAGMENTRESULT_HPP_ */
