/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentResult.cpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FragmentResult.hpp"


/** Constructor of class FragmentResult.
 *
 * \param id id of FragmntJob associated to this FragmentResult.
 */
FragmentResult::FragmentResult(const JobId_t _id) :
  id(_id),
  result(std::string("Nothing"))
{}

/** Copy constructor of class FragmentResult.
 *
 */
FragmentResult::FragmentResult(const FragmentResult &other) :
  id(other.id),
  result(other.result)
{}

/** Destructor of class FragmentResult.
 *
 */
FragmentResult::~FragmentResult()
{}

/** Equality operator: Equal if both ids are the same
 *
 * \param other instance to check against
 * \return true - both ids are the same, false - ids are not the same.
 */
bool FragmentResult::operator==(const FragmentResult &other) const
{
  return id == other.id;
}

/** Assigment operator.
 *
 * \note We can't use default assigment because of const member FragmentResult::id.
 *
 * \param other instance to make equal to
 */
FragmentResult& FragmentResult::operator=(const FragmentResult &other)
{
  /// check self-assignment
  if (this != &other) {
    const_cast<JobId_t &>(id) = other.id;
    result = other.result;
  }
  return *this;
}
