/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * LinearInterpolationofTrajectoriesAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "Helpers/defs.hpp"
#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Dynamics/LinearInterpolationBetweenSteps.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <vector>
#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/LinearInterpolationofTrajectoriesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "LinearInterpolationofTrajectoriesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeLinearInterpolationofTrajectoriesAction::performCall() {
  LOG(0, "STATUS: Linear interpolation between configuration " << params.start.get() << " and " << params.end.get() << "." << endl);
  ASSERT(params.end.get() > params.start.get(), "MoleculeLinearInterpolationofTrajectoriesAction() - start step greater than end step.");
  AtomSetMixin<std::vector<atom*> > set(World::getInstance().getSelectedAtoms());
  LinearInterpolationBetweenSteps<std::vector<atom*> > LinearInterpolate(set,(unsigned int)(params.interpolation_steps.get()));
  LinearInterpolate(params.start.get(), params.end.get(), params.IdMapping.get());
  LOG(0, "STATUS: done." << endl);

  return Action::success;
}

ActionState::ptr MoleculeLinearInterpolationofTrajectoriesAction::performUndo(ActionState::ptr _state) {
//  MoleculeLinearInterpolationofTrajectoriesState *state = assert_cast<MoleculeLinearInterpolationofTrajectoriesState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

ActionState::ptr MoleculeLinearInterpolationofTrajectoriesAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeLinearInterpolationofTrajectoriesAction::canUndo() {
  return false;
}

bool MoleculeLinearInterpolationofTrajectoriesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
