/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * CopyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/UndoRedoHelpers.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Atom/atom.hpp"
#include "Bond/bond.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include "Actions/MoleculeAction/CopyAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "CopyAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeCopyAction::performCall()
{
  std::vector<moleculeId_t> molecules;
  for (World::MoleculeSelectionConstIterator iter = World::getInstance().beginMoleculeSelection();
      iter != World::getInstance().endMoleculeSelection(); ++iter) {
    molecule * const copy = (iter->second)->CopyMolecule();
    Vector *Center = (iter->second)->DetermineCenterOfAll();
    *Center *= -1.;
    *Center += params.position.get();
    copy->Translate(Center);
    delete(Center);
    molecules.push_back(copy->getId());
  }

  return ActionState::ptr(new MoleculeCopyState(molecules,params));
}

ActionState::ptr MoleculeCopyAction::performUndo(ActionState::ptr _state) {
  MoleculeCopyState *state = assert_cast<MoleculeCopyState*>(_state.get());

  RemoveMoleculesWithAtomsByIds(state->copies);

  return ActionState::ptr(_state);
}

ActionState::ptr MoleculeCopyAction::performRedo(ActionState::ptr _state){
  return performCall();
}

bool MoleculeCopyAction::canUndo() {
  return true;
}

bool MoleculeCopyAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
