/*
 * MPQCCommandFragmentController.hpp
 *
 *  Created on: Apr 14, 2014
 *      Author: heber
 */

#ifndef MPQCCOMMANDFRAGMENTCONTROLLER_HPP_
#define MPQCCOMMANDFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/filesystem/path.hpp>
#include <boost/function.hpp>

#include <list>
#include <map>
#include <string>
#include <vector>

#include "Fragmentation/Summation/Containers/MPQCData.hpp"
#include "Fragmentation/Automation/ResultContainer.hpp"

/** This class mimics the interface of SpecificFragmentController derived from
 * JobMarket's FragmentController but without using JobMarket.
 *
 * This is for calculating fragments via MPQCCommandJobs when JobMarket is not
 * available.
 */
class MPQCCommandFragmentController
{
public:
  MPQCCommandFragmentController() :
	  exitflag(0)
  {}
  ~MPQCCommandFragmentController()
  {}

  typedef boost::function<void (const size_t,const size_t)> update_handler_t;

  void setUpdateHandler(update_handler_t _handler)
  {
    handler = _handler;
  }

  /** Command Controller to fill its hold of jobs from FragmentJobQueue.
   *
   * \param _DoSampleDensity whether to actually sample the resulting electronic density
   * \param _DoValenceOnly whether to sample just the valence or the total elctron and nuclei density
   * \param _command command to pass to jobs for execution
   * \return the number of jobs added to queue
   */
  unsigned int addJobsFromQueue(
      const MPQCData::DoLongrange_t _DoLongrange,
      const MPQCData::DoValenceOnly_t _DoValenceOnly,
      const std::string &_command
      );

  /** Mimicks waitforResults but actually does nothing.
   *
   */
  void waitforResults(const size_t NoExpectedResults)
  { return; }

  /** Get results map of calculated jobs.
   *
   * \param fragmentData contains map of results on output
   */
  void getResults(std::map<JobId_t, MPQCData> &fragmentData) {
    fragmentData.insert(results.IdData.begin(), results.IdData.end());
    results.clear();
  }

  /** Runs the service.
   *
   * Here, we finalize each job's id and push them to the server.
   */
  void run();

  /** Mimicks a (unlimited) pool of requested ids that are served by this function.
   *
   * \return next unique job id to use
   */
  unsigned int getAvailableId()
  {
	  return nextid++;
  }

  /** Getter for exitflag.
   *
   * \return exitflag
   */
  int getExitflag() const
  { return exitflag; }

private:
  //!> static member variable to count individual job ids
  static unsigned int nextid;

  //!> overall exit flag of jobs
  int exitflag;

  //!> queue with all jobs to calculate serially
  std::list<MPQCCommandJob *> queue;

  //!> type-specific result container
  ResultContainer<MPQCData> results;

  //!> update handler that is called in waitforResults()
  update_handler_t handler;
};


#endif /* MPQCCOMMANDFRAGMENTCONTROLLER_HPP_ */
