/**
 * @file   vector.cpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Apr 18 12:25:24 2011
 *
 * @brief  VMG::Vector
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "base/index.hpp"
#include "base/vector.hpp"

using namespace VMG;

Vector::Vector(const Index& index)
{
  i[0] = static_cast<vmg_float>(index.X());
  i[1] = static_cast<vmg_float>(index.Y());
  i[2] = static_cast<vmg_float>(index.Z());
}

Vector::Vector(const vmg_float& x, const vmg_float& y, const vmg_float& z)
{
  i[0]=x;
  i[1]=y;
  i[2]=z;
}

Vector::Vector(const vmg_float& val)
{
  std::fill(i, i+3, val);
}

Vector::Vector(const vmg_float* arr)
{
  std::memcpy(i, arr, 3*sizeof(vmg_float));
}

Vector::Vector()
{
  std::fill(i, i+3, 0.0);
}

std::ostream& VMG::operator<<(std::ostream& out, const Vector& vector)
{
  out << "{" << vector.X() << " " << vector.Y() << " " << vector.Z() << "}";

  return out;
}
