/**
 * @file   index.cpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Apr 18 12:19:16 2011
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "base/index.hpp"
#include "base/stencil.hpp"
#include "base/vector.hpp"

using VMG::Index;
using VMG::Vector;

Index::Index(const Index& rhs)
{
  std::memcpy(this->i, rhs.i, 3*sizeof(int));
}

Index::Index(const Vector& vec)
{
  i[0] = static_cast<int>(vec.X());
  i[1] = static_cast<int>(vec.Y());
  i[2] = static_cast<int>(vec.Z());
}

Vector Index::operator+(const Vector& rhs) const
{
  return Vector(*this) += rhs;
}

Vector Index::operator-(const Vector& rhs) const
{
  return Vector(*this) -= rhs;
}

Vector Index::operator*(const Vector& rhs) const
{
  return Vector(*this) *= rhs;
}

Vector Index::operator/(const Vector& rhs) const
{
  return Vector(*this) /= rhs;
}

Vector Index::operator+(const vmg_float& rhs) const
{
  return Vector(*this) += rhs;
}

Vector Index::operator-(const vmg_float& rhs) const
{
  return Vector(*this) -= rhs;
}

Vector Index::operator*(const vmg_float& rhs) const
{
  return Vector(*this) *= rhs;
}

Vector Index::operator/(const vmg_float& rhs) const
{
  return Vector(*this) /= rhs;
}

std::ostream& VMG::operator<<(std::ostream& out, const Index& index)
{
  out << "{" << index.X() << " " << index.Y() << " " << index.Z() << "}";

  return out;
}
