/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

CommandLineDialog::BoxCommandLineQuery::BoxCommandLineQuery(string title, string _description) :
    Dialog::BoxQuery(title, _description)
{}

CommandLineDialog::BoxCommandLineQuery::~BoxCommandLineQuery()
{}

bool CommandLineDialog::BoxCommandLineQuery::handle() {
  BoxValue temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as< BoxValue >();
    RealSpaceMatrix M;
    M.set(0,0, temp.xx);
    M.set(0,1, temp.yx);
    M.set(0,2, temp.zx);
    M.set(1,0, temp.yx);
    M.set(1,1, temp.yy);
    M.set(1,2, temp.zy);
    M.set(2,0, temp.zx);
    M.set(2,1, temp.zy);
    M.set(2,2, temp.zz);
    tmp.setM(M);
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing symmetric box matrix for " << getTitle() << "." << endl);
    return false;
  }
}

