/*
 * QTWorldView.hpp
 *
 *  Created on: Jan 21, 2010
 *      Author: crueger
 */

#ifndef QTMOLECULESVIEW_HPP_
#define QTMOLECULESVIEW_HPP_

#include <QtGui/QTableWidget>
#include "Patterns/Observer.hpp"

class molecule;
class MoleculeListClass;

class QTWorldView : public QTableWidget, public Observer
{
  Q_OBJECT

public:
  QTWorldView(QWidget * _parent=0);
  virtual ~QTWorldView();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);

  static const int COLUMNCOUNT;
  enum {NAME,ATOMS,CENTER,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void moleculeChanged(int row, int column);

  void cellSelected(int row, int column);

signals:
  void moleculeSelected(molecule*);
  void moleculeUnSelected(molecule*);

private:
  std::vector<bool> molSelection; //!< needed to determine when a selection changes
  MoleculeListClass *molecules;
};

#endif /* QTMOLECULESVIEW_HPP_ */
