/*
 * QtMainWindow.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTMAINWINDOW_HPP_
#define QTMAINWINDOW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "UIElements/MainWindow.hpp"
#include <QtGui/QMainWindow>

#include <map>
#include <set>

#include "Menu/Qt4/QtMenu.hpp"

#include "types.hpp"

class QtElementList;
class QtFragmentList;
class QtHomologyList;
class QtLogBox;
class QtMoleculeList;
class QtShapeController;
class StringView;
class GLWorldView;
class QtInfoBox;
class QtStatusBar;
class QtToolBar;
class QCloseEvent;
class QSlider;

class QtObservedInstanceBoard;

class QtMainWindow : public QMainWindow, public MainWindow
{
  Q_OBJECT

public:
  QtMainWindow(QApplication *_theApp);
  virtual ~QtMainWindow();

  virtual void display();

protected:
  virtual void closeEvent(QCloseEvent *event);


private:
  // All kinds of QTStuff used in this window
  QApplication *theApp;
  QtMoleculeList *moleculeList;
  QtElementList *elementList;
  QtHomologyList *homologyList;
  QtFragmentList *fragmentList;
  QtShapeController *shapeController;
  GLWorldView *glWorldView;
  QtInfoBox *infoBox;
  QtStatusBar *statusBar;
  QtMenu<QMenuBar> *MainMenu;
  QtToolBar *toolbar;
  QSlider *timeline;
  QtLogBox *logBox;

  QtObservedInstanceBoard *InstanceBoard;
};

#endif /* QTMAINWINDOW_HPP_ */
