/*
 * QtToolBar.hpp
 *
 *  Created on: Apr 26, 2012
 *      Author: ankele
 */

#ifndef QTTOOLBAR_HPP_
#define QTTOOLBAR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <Qt/qaction.h>
#include <QtGui/QToolBar>

#include "Menu/Qt4/QtMenuPipe.hpp"

#include <map>
#include <set>
#include <string>

#include "CodePatterns/ObservedValue.hpp"
#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Observer/Observer.hpp"


class QtToolBar : public QToolBar, public Observer
{
  Q_OBJECT
public:
  QtToolBar(QWidget * _parent=0);
  virtual ~QtToolBar();

  /** Adds an action named \a token to the toolbar.
   *
   * @param token token of Action
   * @param description description to appear as tooltip
   * @param icon_name name of icon
   * @return ref to newly created action
   */
  QAction * addActionItem(
      const std::string &token,
      const std::string &description,
      const std::string &icon_name);

  /** Function to add a set of favorite actions.
   *
   * @param _max maximum number of actions to add
   */
  void addFavoriteActionItems(const unsigned int _max);

  //!> typedef for a set of action tokens
  typedef std::set<std::string> present_actions_t;

  /** Getter for current set of present action on this toolbar.
   *
   * @return set of action tokens
   */
  const present_actions_t & getPresentActions() const
  { return present_actions; }

  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

private:
  std::list<QtMenuPipe*> plumbing;

  /** This class knows about all Actions being called and stores their frequency.
   *
   * This is used to know about the topmost used Actions and creating placeholder
   * toolbar icons for these on program launch.
   *
   */
  class QtFavoriteActions : public Observer
  {
  public:
    QtFavoriteActions();
    ~QtFavoriteActions();

    void addToolBarActions(
        QtToolBar &_toolbar,
        const unsigned int _max) const;

    void update(Observable *publisher);
    void subjectKilled(Observable *publisher);
    void recieveNotification(Observable *publisher, Notification_ptr notification);

    QIcon getIcon(
        const std::string &_token,
        const std::string &_icon_name
        ) const;

  private:
    QIcon createIconPlaceholder(
        const std::string &_token
        ) const;

    void resetQueuedAction();
    std::string updateQueuedAction() const;

  private:
    //!> cached value of ActionQueue's last action name
    ObservedValue<std::string> LastActionCalled;

    //!> all channels that signal a queued action
    static const Observable::channels_t ActionQueuedChannels;

    //!> typedef for the action counts
    typedef std::map<std::string, unsigned int> ActionCounts_t;
    //!> map counts how often each action has been called
    ActionCounts_t ActionCounts;
    //!> sign in to ActionQueue?
    bool ActionQueue_observing;
  };

  //!> instance dealing with favorite action icons
  QtFavoriteActions FavActions;

  //!> set of already present action icons
  present_actions_t present_actions;

  //!> sign in to ActionQueue?
  bool ActionQueue_observing;
  //!> ref to undoaction to gray out
  QAction *undoaction;
  //!> ref to redoaction to gray out
  QAction *redoaction;
};


#endif /* QTTOOLBAR_HPP_ */
