/*
 * NotAtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAtomByIdAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAtomByIdState : public ActionState {
public:
  SelectionNotAtomByIdState(atom* _walker) :
    walker(_walker)
  {}
  atom* walker;
};

const char SelectionNotAtomByIdAction::NAME[] = "unselect-atom-by-id";

SelectionNotAtomByIdAction::SelectionNotAtomByIdAction() :
  Action(NAME)
{}

SelectionNotAtomByIdAction::~SelectionNotAtomByIdAction()
{}

void SelectionNotAtomById(atom *_atom) {
  ValueStorage::getInstance().setCurrentValue(SelectionNotAtomByIdAction::NAME, _atom);
  ActionRegistry::getInstance().getActionByName(SelectionNotAtomByIdAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAtomByIdAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryAtom(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotAtomByIdAction::performCall() {
  atom *Walker = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, Walker);

  if (World::getInstance().isSelected(Walker)) {
    DoLog(1) && (Log() << Verbose(1) << "Unselecting atom " << *Walker << endl);
    World::getInstance().unselectAtom(Walker);
    return Action::state_ptr(new SelectionNotAtomByIdState(Walker));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionNotAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  if (state->walker != NULL)
    World::getInstance().selectAtom(state->walker);

  return Action::state_ptr(new SelectionNotAtomByIdState(state->walker));
}

Action::state_ptr SelectionNotAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  if (state->walker != NULL)
    World::getInstance().unselectAtom(state->walker);

  return Action::state_ptr(new SelectionNotAtomByIdState(state->walker));
}

bool SelectionNotAtomByIdAction::canUndo() {
  return true;
}

bool SelectionNotAtomByIdAction::shouldUndo() {
  return true;
}

const string SelectionNotAtomByIdAction::getName() {
  return NAME;
}
