/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CreateAdjacencyAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Graph/BondGraph.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <list>
#include <string>

#include "Actions/GraphAction/CreateAdjacencyAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "CreateAdjacencyAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr GraphCreateAdjacencyAction::performCall() {
  BondGraph *BG = World::getInstance().getBondGraph();
  ASSERT(BG != NULL, "GraphCreateAdjacencyAction: BondGraph is NULL.");

  World::AtomComposite Set = World::getInstance().getAllAtoms(AtomsBySelection());
  BG->CreateAdjacency(Set);

  size_t BondCount = 0;
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  for (std::vector<molecule *>::const_iterator iter = molecules.begin();
      iter != molecules.end(); ++iter)
    BondCount += (*iter)->getBondCount();
  LOG(0, "STATUS: Recognized " << BondCount << " bonds.");

  return Action::success;
}

Action::state_ptr GraphCreateAdjacencyAction::performUndo(Action::state_ptr _state) {
//  GraphCreateAdjacencyState *state = assert_cast<GraphCreateAdjacencyState*>(_state.get());

  return Action::success;
}

Action::state_ptr GraphCreateAdjacencyAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool GraphCreateAdjacencyAction::canUndo() {
  return false;
}

bool GraphCreateAdjacencyAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
