/*
 * SeparatorMenuItem.h
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

#ifndef SEPARATORITEM_H_
#define SEPARATORITEM_H_

#include <string>

#include "Menu/TextMenu/MenuItem.hpp"

class TxMenu;

/**
 * Produce a Separator within a Menu.
 *
 * All triggers are ignored for this Item.
 */
class SeparatorMenuItem : public MenuItem
{
public:
  SeparatorMenuItem(TxMenu* const );
  SeparatorMenuItem(TxMenu* const ,char,int);
  ~SeparatorMenuItem();

  virtual void doTrigger();
  virtual bool checkTrigger(char);

  virtual const std::string getDescription();

  virtual const std::string formatEntry();
private:
  char spacer;
  int length;
};

#endif /* SEPARATORITEM_H_ */
