/*
 * DisplayMenuItem.hpp
 *
 *  Created on: Dec 14, 2009
 *      Author: crueger
 */

#ifndef DISPLAYMENUITEM_HPP_
#define DISPLAYMENUITEM_HPP_

#include <string>

#include "Menu/TextMenu/MenuItem.hpp"
#include "defs.hpp"

class StringView;
class TxMenu;

/**
 * Display any kind of StringView within a Menu
 *
 * Any trigger are ignored for this type of Item
 */
class DisplayMenuItem : public MenuItem
{
public:
  DisplayMenuItem(TxMenu* const _menu, StringView *_view);
  DisplayMenuItem(TxMenu* const _menu, StringView *_view, const std::string &_title,
                  char _spacer=STD_MENU_TITLE_SPACER, int _length=STD_MENU_LENGTH);
  ~DisplayMenuItem();

  virtual void doTrigger();
  virtual bool checkTrigger(char);

  virtual const std::string formatEntry();

  virtual const std::string getDescription();

private:
  StringView *view;
  std::string title;
  int length;
  char spacer;
};

#endif /* DISPLAYMENUITEM_HPP_ */
