/*
 * TremoloPotentialTypes.hpp
 *
 *  Created on: Mar 9, 2016
 *      Author: heber
 */


#ifndef TREMOLOPOTENTIALTYPES_HPP_
#define TREMOLOPOTENTIALTYPES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include <boost/bimap.hpp>

/** This class simply contains associations for each potential token
 * to its type, e.g. harmonic_bond belongs to "bonds" in the TREMOLO
 * potentials file.
 */
struct TremoloPotentialTypes
{
  typedef std::string token_t;
  typedef std::string type_t;
  typedef boost::bimap<token_t, type_t> TokenTypeMap_t;

  /** Getter for the type to a given token.
   *
   * \param _token requested token
   * \return type to \a _token
   */
  static const type_t& getTypeFromTokenName(const token_t &_token);

  /** Getter for the token to a given type.
   *
   * \param _type requested type
   * \return token to \a _type
   */
  static const token_t& getTokenFromType(const type_t &_type);

  //!> enumeration of all TREMOLO types
  enum tokentype_t
  {
    particles,
    bonds,
    angles,
    torsions,
    impropers,
    nonbonded_2body_potentials,
    MAX_tokentype
  };

  typedef boost::bimap<tokentype_t, type_t> type_name_map_t;

  /** Getter for the enumerated type giving its name \a _type.
   *
   * \param _type name of the TREMOLO type
   * \return enumerated type
   */
  static const tokentype_t& getTokenTypeFromType(const type_t &_type);

  /** Getter for the name of a TREMOLO type from its enumerated \a _type.
   *
   * \param _type enumerated type
   * \return name of type
   */
  static const type_t& getTypeFromTokenType(const tokentype_t _type);

private:

  //!> static map between the token of an EmpiricalPotential and its TREMOLO type
  static TokenTypeMap_t TokenTypeMap;

  //!> static map between enumerated type and the TREMOLO type
  static type_name_map_t TypeNameMap;
};


#endif /* TREMOLOPOTENTIALTYPES_HPP_ */
