/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TremoloPotentialTypes.cpp
 *
 *  Created on: Mar 9, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "TremoloPotentialTypes.hpp"

#include <boost/assign.hpp>

// static entities

TremoloPotentialTypes::type_name_map_t TremoloPotentialTypes::TypeNameMap =
    boost::assign::list_of< TremoloPotentialTypes::type_name_map_t::relation >
   (particles, "particles")
   (angles, "angles")
   (bonds, "bonds")
   (torsions, "torsions")
   (impropers, "impropers")
   (nonbonded_2body_potentials, "nonbonded_2body_potentials");

TremoloPotentialTypes::TokenTypeMap_t TremoloPotentialTypes::TokenTypeMap =
    boost::assign::list_of< TremoloPotentialTypes::TokenTypeMap_t::relation >
    ( "harmonic_bond", "bonds")
    ( "harmonic_angle", "angles")
    ( "constant", "nonbonded_2body_potentials")
    ( "tersoff", "nonbonded_2body_potentials")
    ( "lennardjones", "nonbonded_2body_potentials")
    ( "morse", "bonds")
    ( "torsion", "torsions")
    ( "improper", "impropers");

static const std::string emptystring;
static const TremoloPotentialTypes::tokentype_t emptytoken = TremoloPotentialTypes::MAX_tokentype;

const TremoloPotentialTypes::type_t &
TremoloPotentialTypes::getTypeFromTokenName(const token_t &_token)
{
  const TokenTypeMap_t::left_const_iterator tokeniter = TokenTypeMap.left.find(_token);
  if (tokeniter != TokenTypeMap.left.end())
    return tokeniter->second;
  else
    return emptystring;
}

const TremoloPotentialTypes::token_t &
TremoloPotentialTypes::getTokenFromType(const type_t &_type)
{
  const TokenTypeMap_t::right_const_iterator typeiter = TokenTypeMap.right.find(_type);
  if (typeiter != TokenTypeMap.right.end())
    return typeiter->second;
  else
    return emptystring;
}

const TremoloPotentialTypes::tokentype_t&
TremoloPotentialTypes::getTokenTypeFromType(const type_t &_type)
{
  const type_name_map_t::right_const_iterator typeiter = TypeNameMap.right.find(_type);
  if (typeiter != TypeNameMap.right.end())
    return typeiter->second;
  else
    return emptytoken;
}

const TremoloPotentialTypes::type_t&
TremoloPotentialTypes::getTypeFromTokenType(const tokentype_t _tokentype)
{
  const type_name_map_t::left_const_iterator tokeniter = TypeNameMap.left.find(_tokentype);
  if (tokeniter != TypeNameMap.left.end())
    return tokeniter->second;
  else
    return emptystring;
}
