/*
 * StockClient.cpp
 *
 *  Created on: Nov 18, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <iostream>
#include <vector>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include <boost/serialization/vector.hpp>
#include "CodePatterns/Info.hpp"
#include "FragmentJob.hpp"
#include "StockClient.hpp"

/// Constructor starts the asynchronous connect operation.
StockClient::StockClient(
    boost::asio::io_service& io_service,
    const std::string& host,
    const std::string& service) :
  connection_(io_service)
{
    Info info(__FUNCTION__);
  // Resolve the host name into an IP address.
  boost::asio::ip::tcp::resolver resolver(io_service);
  boost::asio::ip::tcp::resolver::query query(host, service);
  boost::asio::ip::tcp::resolver::iterator endpoint_iterator =
    resolver.resolve(query);
  boost::asio::ip::tcp::endpoint endpoint = *endpoint_iterator;

  // Start an asynchronous connect operation.
  connection_.socket().async_connect(endpoint,
    boost::bind(&StockClient::handle_connect, this,
      boost::asio::placeholders::error));
}

/// Handle completion of a connect operation.
void StockClient::handle_connect(const boost::system::error_code& e)
{
    Info info(__FUNCTION__);
  if (!e)
  {
    // Successfully established connection. Start operation to read the list
    // of stocks. The connection::async_read() function will automatically
    // decode the data that is read from the underlying socket.
    connection_.async_read(jobs_,
      boost::bind(&StockClient::handle_read, this,
      boost::asio::placeholders::error));
  }
  else
  {
    // An error occurred. Log it and return. Since we are not starting a new
    // operation the io_service will run out of work to do and the client will
    // exit.
    std::cerr << e.message() << std::endl;
  }
}

/// Handle completion of a read operation.
void StockClient::handle_read(const boost::system::error_code& e)
{
    Info info(__FUNCTION__);
  if (!e)
  {
    // Print out the data that was received.
    for (std::size_t i = 0; i < jobs_.size(); ++i)
    {
        std::cout << "Job number " << i << "\n";
        std::cout << "  output: " << jobs_[i].outputfile << "\n";
        std::cout << "  id: " << jobs_[i].JobId << "\n";
    }
  }
  else
  {
    // An error occurred.
    std::cerr << e.message() << std::endl;
  }

  // Since we are not starting a new operation the io_service will run out of
  // work to do and the client will exit.
}

