/*
 * QtQueryPipe.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef QTQUERYPIPE_HPP_
#define QTQUERYPIPE_HPP_

// All kinds of plumbing for Queries
// Plumbing needs to be outside of the class where it is needed,
// since MOC doesn't like nested classes

#include <Qt/qwidget.h>

#include <vector>

#include "CodePatterns/MemDebug.hpp"

class QLineEdit;
class QListWidget;
class QPushButton;

class QtDialog;

template<typename T> class QtQueryListPipe : public QWidget {
  public:
    QtQueryListPipe(std::vector<T> *_content, QtDialog *_dialog, QLineEdit *_inputBox, QListWidget *_inputList, QPushButton *_AddButton, QPushButton *_RemoveButton);
    virtual ~QtQueryListPipe();
    void AddInteger();
    void RemoveInteger();
    void IntegerSelected();
    void IntegerEntered(const QString&);

  private:
    void AddValue(T item);
    void RemoveRow(int row);

    std::vector<T> *content;
    QtDialog *dialog;
    QLineEdit *inputBox;
    QListWidget *inputList;
    QPushButton *AddButton;
    QPushButton *RemoveButton;
};

#endif /* QTQUERYPIPE_HPP_ */
