/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculesQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/MoleculesQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <vector>

#include <Qt/qcombobox.h>

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"


MoleculesQtQueryPipe::MoleculesQtQueryPipe(std::vector<const molecule *>*_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

MoleculesQtQueryPipe::~MoleculesQtQueryPipe()
{}

void MoleculesQtQueryPipe::update(int newIndex) {
  QVariant data = theBox->itemData(newIndex);
  int idx = data.toInt();
  molecule *mol = World::getInstance().getMolecule(MoleculeById(idx));
  if (mol)
    (*content).push_back(mol);
  dialog->update();
}

