/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/MoleculeQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qcombobox.h>

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"


MoleculeQtQueryPipe::MoleculeQtQueryPipe(const molecule **_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

MoleculeQtQueryPipe::~MoleculeQtQueryPipe()
{}

void MoleculeQtQueryPipe::update(int newIndex) {
  QVariant data = theBox->itemData(newIndex);
  int idx = data.toInt();
  (*content) = World::getInstance().getMolecule(MoleculeById(idx));
  dialog->update();
}


