/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/ElementsQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <vector>

#include <Qt/qcombobox.h>

#include "CodePatterns/MemDebug.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"


ElementsQtQueryPipe::ElementsQtQueryPipe(std::vector<const element *>*_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

ElementsQtQueryPipe::~ElementsQtQueryPipe()
{}

void ElementsQtQueryPipe::update(int newIndex) {
  QVariant data = theBox->itemData(newIndex);
  int idx = data.toInt();
  const element *elemental = World::getInstance().getPeriode()->FindElement(idx);
  if(elemental)
    (*content).push_back(elemental);
  dialog->update();
}

