/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/AtomQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qcombobox.h>

#include "Descriptors/AtomIdDescriptor.hpp"
#include "CodePatterns/MemDebug.hpp"
#include "World.hpp"


AtomQtQueryPipe::AtomQtQueryPipe(const atom **_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

AtomQtQueryPipe::~AtomQtQueryPipe()
{}

void AtomQtQueryPipe::update(int newIndex) {
  QVariant data = theBox->itemData(newIndex);
  int idx = data.toInt();
  (*content) = World::getInstance().getAtom(AtomById(idx));
  dialog->update();
}


