/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TxMenuLeaveAction.cpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Action.hpp"
#include "Actions/ActionTraits.hpp"
#include "Menu/TextMenu/TxMenuLeaveAction.hpp"
#include "CodePatterns/Assert.hpp"

/** Constructor for class TxMenu::LeaveAction.
 * \param _menu pointer to the containing TxMenu
 * \param &LeaveActionTrait ActionTraits for this Action
 */
TxMenu::LeaveAction::LeaveAction(TxMenu* const _menu, const ActionTraits & LeaveActionTrait) :
  Action(LeaveActionTrait, true),
  menu(_menu)
{}

/** Destructor for class TxMenu::LeaveAction.
 *
 */
TxMenu::LeaveAction::~LeaveAction(){}

/** We can't undo the leave action.
 * \return false
 */
bool TxMenu::LeaveAction::canUndo(){
  return false;
}

/** We should never undo the leave action.
 * \return false
 */
bool TxMenu::LeaveAction::shouldUndo(){
  return false;
}

/** Internal function to obtain parameters from a storage.
 * We do not use this one as we don't need any parameters.
 */
void TxMenu::LeaveAction::getParametersfromValueStorage()
{}

/** Internal function to construct the dialog.
 * We do not need this function as there is no dialog to construct.
 */
Dialog* TxMenu::LeaveAction::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

/** Calls TxMenu::doQuit() on the stored menu reference.
 * \return ActionState pointer with success
 */
Action::state_ptr TxMenu::LeaveAction::performCall(){
  menu->doQuit();
  return Action::success;
}

/** Implementation of undo function for an Action.
 * We do not use this functionality.
 * \return ActionState pointer with failure
 */
Action::state_ptr TxMenu::LeaveAction::performUndo(Action::state_ptr){
  ASSERT(0,"Cannot undo leaving a menu");
  return Action::failure;
}

/** Implementation of redo function for an Action.
 * We do not use this functionality.
 * \return ActionState pointer with failure
 */
Action::state_ptr TxMenu::LeaveAction::performRedo(Action::state_ptr){
  ASSERT(0,"Cannot redo leaving a menu");
  return Action::failure;
}
