/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SeparatorMenuItem.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <string>
#include <sstream>

#include "Menu/TextMenu/SeparatorMenuItem.hpp"
#include "Helpers/defs.hpp"


SeparatorMenuItem::SeparatorMenuItem(TxMenu* const menu):
  MenuItem('\0',"",menu),
  spacer(STD_SEPERATOR_SPACER),
  length(STD_MENU_LENGTH)
{
  // TODO Auto-generated constructor stub

}

SeparatorMenuItem::SeparatorMenuItem(TxMenu* const menu,char _spacer, int _length):
  MenuItem('\0',"",menu),
  spacer(_spacer),
  length(_length)
{
  // TODO Auto-generated constructor stub

}

SeparatorMenuItem::~SeparatorMenuItem()
{
  // TODO Auto-generated destructor stub
}


void SeparatorMenuItem::doTrigger(){}
bool SeparatorMenuItem::checkTrigger(char){
  return false;
}

const std::string SeparatorMenuItem::getDescription() {
  return std::string("");
}

const std::string SeparatorMenuItem::formatEntry(){
  std::stringstream s;
  for(int i=0; i<length;i++)
    s << spacer;
  return s.str();
}
