/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MenuItem.cpp
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Menu/TextMenu/MenuItem.hpp"
#include "Menu/TextMenu/TxMenu.hpp"
#include "Menu/Menu.hpp"
#include <sstream>

/**
 * produce a new MenuItem using with a description and a trigger.
 * The MenuItem is then added to the menu passed to it.
 */
MenuItem::MenuItem(char _trigger, const std::string &_description,TxMenu* const menu) :
  trigger(_trigger),
  description(_description),
  added(false)
{
  add_to_menu(menu);
}

MenuItem::~MenuItem()
{}

/**
 * check if the trigger matches and call doTrigger if it does.
 */
bool MenuItem::checkTrigger(char key) {
  if(key == trigger) {
    doTrigger();
    return true;
  }
  else
    return false;

}

char MenuItem::getTrigger() {
  return trigger;
}

const std::string MenuItem::getDescription() {
  return description;
}

/**
 * Produce a formated output of this item containing trigger and description
 * Normal format is: "<trigger> - <description>"
 */
const std::string MenuItem::formatEntry(){
  std::stringstream s;
  s << getTrigger() << " - " << getDescription();

  return s.str();
}


/**
 * check if this item is within a menu and add to menu if it is not yet contained anywhere
 *
 * TODO: include funtionality to move Items from one menu to another
 */
void MenuItem::add_to_menu(TxMenu* const menu) {
  if(!wasAdded()) {
    menu->addItem(this);
    added=true;
  }
}

bool MenuItem::wasAdded(){
  return added;
}

bool MenuItem::isActive(){
  return true;
}
