/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtMenuPipe.cpp
 *
 *  Created on: Nov 5, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qaction.h>

#include "CodePatterns/MemDebug.hpp"

#include "QtMenuPipe.hpp"

#include "Actions/ActionRegistry.hpp"
#include "Actions/Action.hpp"

QtMenuPipe::QtMenuPipe(const std::string &_ActionName, QAction *_action) :
    ActionName(_ActionName), theAction(_action)
{}

QtMenuPipe::~QtMenuPipe() {
  delete theAction;
}

void QtMenuPipe::called() {
  Action* action = ActionRegistry::getInstance().getActionByName(ActionName);
  action->call();
}
