/*
 * MenuDescription.hpp
 *
 *  Created on: Oct 26, 2010
 *      Author: heber
 */

#ifndef MENUDESCRIPTION_HPP_
#define MENUDESCRIPTION_HPP_

#include <map>
#include <set>
#include <string>

#include "CodePatterns/Singleton.hpp"

class MenuDescriptionTest;

/** Class contains information on menus.
 *
 */
class MenuDescription : public Singleton<MenuDescription>
{
  friend class MenuDescriptionTest;
  friend class Singleton<MenuDescription>;
public:

  typedef std::pair<std::string const, int const> TopPosition;
  typedef std::map<std::string const, TopPosition const> IterableMap;
  typedef IterableMap::iterator iterator;
  typedef IterableMap::const_iterator const_iterator ;
  typedef std::map<std::string const, std::string const> TextMap;

  // getter for description
  const std::string getDescription(const std::string &token) const;
  const std::string getName(const std::string &token) const;

  //std::multimap <std::string, std::string> getMenuItemsMap() const;

  // iterators
  iterator getBeginIter();
  iterator getEndIter();
  const_iterator getBeginIter() const;
  const_iterator getEndIter() const;

private:
  MenuDescription();
  ~MenuDescription();

  static TextMap *MenuDescriptionsMap;
  static IterableMap *MenuPositionMap;
  static TextMap *MenuNameMap;
};

#endif /* MENUDESCRIPTION_HPP_ */
