/**
 * @file   error_handler.cpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Nov 21 13:27:22 2011
 *
 * @brief  Convert MPI errors to C++ exceptions. Used to be
 *         able to call a debugger when MPI crashes
 *         internally.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MPI

#include <mpi.h>
#ifdef HAVE_MARMOT
#include <enhancempicalls.h>
#include <sourceinfompicalls.h>
#endif

#include "comm/mpi/error_handler.hpp"

void VMG::MPI::ConvertToException(MPI_Comm* comm, int* err, ...)
{
  char error_string[MPI_MAX_ERROR_STRING];
  int resultlen;
  MPI_Error_string(*err, error_string, &resultlen);
  throw Exception(error_string);
}

#endif /* HAVE_MPI */
