/*
 * ActOnAllUnitTest.cpp
 *
 *  Created on: 04.10.2009
 *      Author: FrederikHeber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ActOnAlltest.hpp"
#include "ActOnAllUnitTest.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ActOnAllTest );


void ActOnAllTest::setUp()
{
  Vector *temp = NULL;
  // fill list with vectors
  temp = new Vector(1,0,0);
  VL.AddVector(temp);
  temp = new Vector(0,1,0);
  VL.AddVector(temp);
  temp = new Vector(0,0,1);
  VL.AddVector(temp);
};


void ActOnAllTest::tearDown()
{
  VL.EmptyList();
};

/** UnitTest for VectorList::ActOnAllVectors()
 */
void ActOnAllTest::ListTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
