#ifndef PERIODENTAFEL_HPP_
#define PERIODENTAFEL_HPP_

using namespace std;

#include "defs.hpp"
#include "helpers.hpp"

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ====================================== class definitions =========================

class element;
class periodentafel;

/** Chemical element.
 * Class incorporates data for a certain chemical element to be referenced from atom class.
 */
class element {
	public:
		double mass;		//!< mass in g/mol
		double CovalentRadius;	//!< covalent radius
		double VanDerWaalsRadius;	//!< can-der-Waals radius
		int Z;					//!< atomic number
		char name[64];	//!< atom name, i.e. "Hydrogren"
		char symbol[3]; //!< short form of the atom, i.e. "H"
		char period[8];		//!< period: n quantum number
		char group[8];		//!< group: l quantum number
		char block[8];		//!< block: l quantum number
		element *previous;	//!< previous item in list
		element *next;	//!< next element in list
		int *sort;			//!< sorc criteria
		int No;				 //!< number of element set on periodentafel::Output()
		double Valence;	 //!< number of valence electrons for this element
		int NoValenceOrbitals;	//!< number of valence orbitals, used for determining bond degree in molecule::CreateConnectmatrix()
		double HBondDistance[NDIM]; //!< distance in Angstrom of this element to hydrogen	(for single, double and triple bonds)
		double HBondAngle[NDIM];		 //!< typical angle for one, two, three bonded hydrogen (in degrees)

	element();
	~element();

	//> print element entries to screen
	bool Output(ofstream *out) const;
	bool Checkout(ofstream *out, const int No, const int NoOfAtoms) const;

	private:
};

/** Periodentafel is a list of all elements sorted by their atomic number.
 */
class periodentafel {
	public:
		element *start; //!< start of element list
		element *end;	 //!< end of element list
		char header1[MAXSTRINGSIZE]; //!< store first header line
		char header2[MAXSTRINGSIZE]; //!< store second header line

	periodentafel();
	~periodentafel();

	bool AddElement(element *pointer);
	bool RemoveElement(element *pointer);
	bool CleanupPeriodtable();
	element * FindElement(int Z);
	element * FindElement(const char *shorthand) const;
	element * AskElement();
	bool Output(ofstream *output) const;
	bool Checkout(ofstream *output, const int *checkliste) const;
	bool LoadPeriodentafel(const char *path);
	bool StorePeriodentafel(const char *path) const;

	private:
};


#endif /*PERIODENTAFEL_HPP_*/
