/*
 * ParserUnitTest.cpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */

#include "ParserUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parser/XyzParser.hpp"
#include "World.hpp"
#include "element.hpp"
#include "periodentafel.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParserUnitTest );


void ParserUnitTest::setUp() {
  element* oxygen = new element();
  oxygen->symbol[0] = 'O';
  oxygen->Z = 8;
  World::get()->getPeriode()->AddElement(oxygen);

  element* hydrogen = new element();
  hydrogen->symbol[0] = 'H';
  hydrogen->Z = 1;
  World::get()->getPeriode()->AddElement(hydrogen);
}

void ParserUnitTest::tearDown() {
}

/************************************ tests ***********************************/

void ParserUnitTest::rewriteAnXyzTest() {
  XyzParser* testParser = new XyzParser();
  string waterXyz = "3\nH2O: water molecule\nO\t0.000000\t0.000000\t0.000000\nH\t0.758602\t0.000000\t0.504284\nH\t0.758602\t0.000000\t-0.504284\n";
  stringstream input;
  input << waterXyz;
  testParser->load(&input);

  CPPUNIT_ASSERT_EQUAL(3, World::get()->numAtoms());

  string newWaterXyz = "";
  stringstream output;
  testParser->save(&output);
  newWaterXyz = output.str();

  CPPUNIT_ASSERT(waterXyz == newWaterXyz);
}

