/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetWorldTimeAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "WorldTime.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/SetWorldTimeAction.hpp"

// and construct the stuff
#include "SetWorldTimeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldSetWorldTimeAction::performCall() {
  // create undo state
  int oldtime;
  oldtime = WorldTime::getInstance().getTime();
  WorldSetWorldTimeState *UndoState = new WorldSetWorldTimeState(oldtime, params);

  // obtain information
  getParametersfromValueStorage();

  WorldTime::getInstance().setTime(params.newtime);
  DoLog(0) && (Log() << Verbose(0) << "Current time step is now: " << WorldTime::getInstance().getTime() << "." << endl);
  return Action::state_ptr(UndoState);
}

Action::state_ptr WorldSetWorldTimeAction::performUndo(Action::state_ptr _state) {
  WorldSetWorldTimeState *state = assert_cast<WorldSetWorldTimeState*>(_state.get());

  WorldTime::getInstance().setTime(state->oldtime);
  DoLog(0) && (Log() << Verbose(0) << "Current time step is now again: " << WorldTime::getInstance().getTime() << "." << endl);

  return Action::state_ptr(_state);
}

Action::state_ptr WorldSetWorldTimeAction::performRedo(Action::state_ptr _state){
  WorldSetWorldTimeState *state = assert_cast<WorldSetWorldTimeState*>(_state.get());

  WorldTime::getInstance().setTime(state->params.newtime);
  DoLog(0) && (Log() << Verbose(0) << "Current time step is now: " << WorldTime::getInstance().getTime() << "." << endl);

  return Action::state_ptr(_state);
}

bool WorldSetWorldTimeAction::canUndo() {
  return true;
}

bool WorldSetWorldTimeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
