#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <iostream>

// STL headers
#include <map>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class atom;
class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class config;
class LinkedCell;
class molecule;
class MoleculeListClass;
class Tesselation;
class Vector;

/********************************************** definitions *********************************/

#define DEBUG 1
#define DoSingleStepOutput 0
#define SingleStepWidth 1

#define DistancePair pair < double, atom* >
#define DistanceMap multimap < double, atom* >
#define DistanceTestPair pair < DistanceMap::iterator, bool>

#define Boundaries map <double, DistancePair >
#define BoundariesPair pair<double, DistancePair >
#define BoundariesTestPair pair< Boundaries::iterator, bool>

/********************************************** declarations *******************************/

double ConvexizeNonconvexEnvelope(ofstream *out, class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
molecule * FillBoxWithMolecule(ofstream *out, MoleculeListClass *List, molecule *filler, config &configuration, double distance[NDIM], double RandAtomDisplacement, double RandMolDisplacement, bool DoRandomRotation);
void FindConvexBorder(ofstream *out, const molecule* const mol, Tesselation *&TesselStruct, const LinkedCell *LCList, const char *filename);
Vector* FindEmbeddingHole(ofstream *out, MoleculeListClass *mols, molecule *srcmol);
void FindNextSuitablePoint(class BoundaryTriangleSet *BaseTriangle, class BoundaryLineSet *BaseLine, atom*& OptCandidate, Vector *OptCandidateCenter, double *ShortestAngle, const double RADIUS, LinkedCell *LC);
void FindNonConvexBorder(ofstream *out, const molecule* const mol, Tesselation *&TesselStruct, const LinkedCell *&LC, const double RADIUS, const char *tempbasename);
Boundaries *GetBoundaryPoints(ofstream *out, const molecule *mol, Tesselation *&TesselStruct);
double * GetDiametersOfCluster(ofstream *out, const Boundaries *BoundaryPtr, const molecule *mol, Tesselation *&TesselStruct, const bool IsAngstroem);
void PrepareClustersinWater(ofstream *out, config *configuration, molecule *mol, double ClusterVolume, double celldensity);
bool RemoveAllBoundaryPoints(ofstream *out, class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
void StoreTrianglesinFile(ofstream *out, const molecule * const mol, const Tesselation *&TesselStruct, const char *filename, const char *extraSuffix);
double VolumeOfConvexEnvelope(ofstream *out, class Tesselation *TesselStruct, class config *configuration);


#endif /*BOUNDARY_HPP_*/
