/*
 * RemoveFromPoolOperation.hpp
 *
 *  Created on: Mar 01, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_
#define FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Controller/Commands/SyncOperation.hpp"
#include "WorkerAddress.hpp"

class RemoveFromPoolOperation : public SyncOperation  {
public:
  /// Constructor for class RemoveFromPoolOperation.
  RemoveFromPoolOperation(Connection &_connection, const WorkerAddress &_address) :
    SyncOperation(std::string("shutdownworker"),_connection),
    address(_address)
  {}
  /// Destructor for class RemoveFromPoolOperation
  ~RemoveFromPoolOperation() {}

public:
  // function that implements read&writes in between connect/disconnect
  virtual void internal();

private:
  //!> address to enroll with
  WorkerAddress address;
};

#endif /* FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_ */
