/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RemoveFromPoolOperation.cpp
 *
 *  Created on: Mar 01, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <iostream>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "CodePatterns/Info.hpp"
#include "CodePatterns/Log.hpp"
#include "WorkerChoices.hpp"

#include "Controller/Commands/RemoveFromPoolOperation.hpp"

/** Internal operation after connect to give address and send remove signal
 *
 */
void RemoveFromPoolOperation::internal()
{
  Info info(__FUNCTION__);

  LOG(1, "INFO: Removing " << address << " from server's pool ...");
  connection_.sync_write(address);
  enum WorkerChoices choice = RemoveFromPool;
  connection_.sync_write(choice);
}
