/*
 * MoleculeFormulaDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

#include "MoleculeFormulaDescriptor.hpp"
#include "MoleculeFormulaDescriptor_impl.hpp"

#include "molecule.hpp"


MoleculeFormulaDescriptor_impl::MoleculeFormulaDescriptor_impl(const Formula &_formula) :
  formula(_formula)
{}

MoleculeFormulaDescriptor_impl::~MoleculeFormulaDescriptor_impl(){}

bool MoleculeFormulaDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule){
  return molecule.second->getFormula() == formula;
}


MoleculeDescriptor MoleculeByFormula(const Formula &formula)
{
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeFormulaDescriptor_impl(formula)));
}

MoleculeDescriptor MoleculeByFormula(const std::string &_formula) throw(ParseError){
  Formula formula(_formula);
  return MoleculeByFormula(formula);
}
