/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeLeafClass.cpp
 *
 *  Created on: Oct 20, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "MoleculeLeafClass.hpp"

#include "CodePatterns/Log.hpp"

#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "Fragmentation/AtomMask.hpp"
#include "Fragmentation/Graph.hpp"
#include "Fragmentation/KeySet.hpp"
#include "Graph/ListOfLocalAtoms.hpp"
#include "molecule.hpp"

/** Constructor for MoleculeLeafClass root leaf.
 * \param *Up Leaf on upper level
 * \param *PreviousLeaf NULL - We are the first leaf on this level, otherwise points to previous in list
 */
//MoleculeLeafClass::MoleculeLeafClass(MoleculeLeafClass *Up = NULL, MoleculeLeafClass *Previous = NULL)
MoleculeLeafClass::MoleculeLeafClass(MoleculeLeafClass *PreviousLeaf = NULL) :
  Leaf(NULL),
  previous(PreviousLeaf)
{
  //  if (Up != NULL)
  //    if (Up->DownLeaf == NULL) // are we the first down leaf for the upper leaf?
  //      Up->DownLeaf = this;
  //  UpLeaf = Up;
  //  DownLeaf = NULL;
  if (previous != NULL) {
    MoleculeLeafClass *Walker = previous->next;
    previous->next = this;
    next = Walker;
  } else {
    next = NULL;
  }
};

/** Destructor for MoleculeLeafClass.
 */
MoleculeLeafClass::~MoleculeLeafClass()
{
  //  if (DownLeaf != NULL) {// drop leaves further down
  //    MoleculeLeafClass *Walker = DownLeaf;
  //    MoleculeLeafClass *Next;
  //    do {
  //      Next = Walker->NextLeaf;
  //      delete(Walker);
  //      Walker = Next;
  //    } while (Walker != NULL);
  //    // Last Walker sets DownLeaf automatically to NULL
  //  }
  // remove the leaf itself
  if (Leaf != NULL)
    removeAtomsinMolecule(Leaf);
  // remove this Leaf from level list
  if (previous != NULL)
    previous->next = next;
  //  } else { // we are first in list (connects to UpLeaf->DownLeaf)
  //    if ((NextLeaf != NULL) && (NextLeaf->UpLeaf == NULL))
  //      NextLeaf->UpLeaf = UpLeaf;  // either null as we are top level or the upleaf of the first node
  //    if (UpLeaf != NULL)
  //      UpLeaf->DownLeaf = NextLeaf;  // either null as we are only leaf or NextLeaf if we are just the first
  //  }
  //  UpLeaf = NULL;
  if (next != NULL) // are we last in list
    next->previous = previous;
  next = NULL;
  previous = NULL;
};

/** Adds \a molecule leaf to the tree.
 * \param *ptr ptr to molecule to be added
 * \param *Previous previous MoleculeLeafClass referencing level and which on the level
 * \return true - success, false - something went wrong
 */
bool MoleculeLeafClass::AddLeaf(molecule *ptr, MoleculeLeafClass *Previous)
{
  return false;
};



/** Simply counts the number of items in the list, from given MoleculeLeafClass.
 * \return number of items
 */
int MoleculeLeafClass::Count() const
{
  if (next != NULL)
    return next->Count() + 1;
  else
    return 1;
};

