/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"

QtDialog::AtomQtQuery::AtomQtQuery(Parameter<const atom *> &_param, const std::string &_title, const std::string &_description,QBoxLayout *_parent,Dialog *_dialog) :
    QtQuery<const atom *>(_param, _title, _description),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  titleLabel->setToolTip(QString(getDescription().c_str()));
  inputBox = new QComboBox();
  inputBox->insertItem(-1, QString("no atom"));
  std::vector<const atom *> atoms = const_cast<const World &>(World::getInstance()).
      getAllAtoms();
  for (std::vector<const atom *>::const_iterator iter = atoms.begin(); iter != atoms.end(); ++iter)
    inputBox->insertItem((*iter)->getNr(),QString::fromStdString((*iter)->getName()));

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  onUpdate(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::AtomQtQuery::~AtomQtQuery()
{
}

void QtDialog::AtomQtQuery::onUpdate(int newIndex) {
  QVariant data = inputBox->itemData(newIndex);
  int idx = data.toInt();
  temp = const_cast<const World &>(World::getInstance()).getAtom(AtomById(idx));
  dialog->update();
}


