/*
 * FragmentUnitTest.hpp
 *
 *  Created on: Aug 09, 2012
 *      Author: heber
 */

#ifndef FRAGMENTUNITTEST_HPP_
#define FRAGMENTUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "Fragmentation/SetValues/Fragment.hpp"

/********************************************** Test classes **************************************/

class FragmentTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( FragmentTest) ;
    CPPUNIT_TEST ( isPositionEqual_Test );
    CPPUNIT_TEST ( containsNuclei_Test );
    CPPUNIT_TEST ( removeNuclei_Test );
    CPPUNIT_TEST ( equalityNucleus_Test );
    CPPUNIT_TEST ( equality_Test );
    CPPUNIT_TEST ( assignment_Test );
    CPPUNIT_TEST ( operatorPlusEqual_NonOverlapping_Test );
    CPPUNIT_TEST ( operatorPlusEqual_Test );
    CPPUNIT_TEST ( operatorMinusEqual_NonOverlapping_Test );
    CPPUNIT_TEST ( operatorMinusEqual_Test );
    CPPUNIT_TEST ( serializeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void isPositionEqual_Test();
      void containsNuclei_Test();
      void removeNuclei_Test();
      void equalityNucleus_Test();
      void equality_Test();
      void assignment_Test();
      void operatorPlusEqual_NonOverlapping_Test();
      void operatorPlusEqual_Test();
      void operatorMinusEqual_NonOverlapping_Test();
      void operatorMinusEqual_Test();
      void serializeTest();

private:
      Fragment *fragment;
      Fragment::positions_t positions;
      Fragment::charges_t charges;
};

#endif /* FRAGMENTUNITTEST_HPP_ */
