/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/FragmentationAction/FragmentationAction.hpp"

// and construct the stuff
#include "FragmentationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationFragmentationAction::performCall() {
  clock_t start,end;
  molecule *mol = NULL;
  config *configuration = World::getInstance().getConfig();
  int ExitFlag = 0;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    ASSERT(mol != NULL, "No molecule has been picked for fragmentation.");
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with bond distance " << params.distance << " angstroem, order of " << params.order << "." << endl);
    DoLog(0) && (Log() << Verbose(0) << "Creating connection matrix..." << endl);
    start = clock();
    mol->CreateAdjacencyList(params.distance, configuration->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, NULL);
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with current connection matrix ..." << endl);
    if (mol->hasBondStructure()) {
      ExitFlag = mol->FragmentMolecule(params.order, params.path);
    }
    World::getInstance().setExitFlag(ExitFlag);
    end = clock();
    DoLog(0) && (Log() << Verbose(0) << "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s." << endl);
  }
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationFragmentationAction::canUndo() {
  return true;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
