/*
 * TxMenuLeaveAction.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef TXMENULEAVEACTION_HPP_
#define TXMENULEAVEACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Menu/TextMenu/TxMenu.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionTrait.hpp"

/** This specific action is used to leave a submenu and return to an upper one.
 * It differs from other Action's (and thus cannot be put into the usual
 * structure) that we have to store the reference to the menu it belongs to.
 * There, we call the doQuit() member function on performCall().
 */
class TxMenu::LeaveAction : public MoleCuilder::Action 
{
public:
  LeaveAction(TxMenu* const, const MoleCuilder::ActionTrait &_trait);
  virtual ~LeaveAction();

  bool canUndo();
  bool shouldUndo();

protected:
  virtual Dialog* fillDialog(Dialog *dialog);
private:
  virtual MoleCuilder::Action::state_ptr performCall();
  virtual MoleCuilder::Action::state_ptr performUndo(MoleCuilder::Action::state_ptr);
  virtual MoleCuilder::Action::state_ptr performRedo(MoleCuilder::Action::state_ptr);

  TxMenu* const menu;
};

#endif /* TXMENULEAVEACTION_HPP_ */
