/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberGeneratorUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Assert.hpp"

#include "RandomNumberGeneratorUnitTest.hpp"

#include "RandomNumbers/RandomNumberGenerator.hpp"
#include "RandomNumbers/RandomNumberGeneratorFactory.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( RandomNumberGeneratorTest );

void RandomNumberGeneratorTest::setUp()
{
}

void RandomNumberGeneratorTest::tearDown()
{
  RandomNumberDistributionFactory::purgeInstance();
  RandomNumberEngineFactory::purgeInstance();
  RandomNumberGeneratorFactory::purgeInstance();
}

/** We check that the RandomNumberGenerator instance received
 * from the RandomNumberGeneratorFactory is truely the prototype
 * itself.
 */
void RandomNumberGeneratorTest::PrototypeNonCopyTest()
{
  RandomNumberGenerator &rng1 = RandomNumberGeneratorFactory::getInstance().makeRandomNumberGenerator();
  RandomNumberGenerator &rng2 = RandomNumberGeneratorFactory::getInstance().makeRandomNumberGenerator();

  // compare addresses in memory, have to be the same
  CPPUNIT_ASSERT( &rng1 == &rng2 );
}

void RandomNumberGeneratorTest::Range_uniform_smallint_Test()
{
  // obtain some random values for uniform_smallint
  RandomNumberGeneratorFactory::getInstance().setDistribution("uniform_smallint");
  RandomNumberGenerator& rng = RandomNumberGeneratorFactory::getInstance().makeRandomNumberGenerator();
  for (size_t i=0; i < 1000; ++i) {
    const int testint = rng();
    CPPUNIT_ASSERT_MESSAGE("randon number from uniform_smallint is out of [0:9]!", testint >= 0);
    CPPUNIT_ASSERT_MESSAGE("randon number from uniform_smallint is out of [0:9]!", testint <= 9);
  }
}
