/** \file helpers.hpp
 *
 * Declaration of some auxiliary functions for memory dis-/allocation and so on
 */

#ifndef HELPERS_HPP_
#define HELPERS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>

#include "Helpers/defs.hpp"
#include "CodePatterns/Log.hpp"

/********************************************** definitions *********************************/

/********************************************** helpful functions *********************************/

// taken out of TREMOLO
/*@-namechecks@*/
#ifndef __GNUC__
# undef __attribute__
# define __attribute__(x)
#endif
/*@=namechecks@*/

/* Behandelt aufgetretene Fehler. error ist der Fehlertyp(enum Errors)
   void *SpecialData ist ein untypisierter Zeiger auf Spezielle Daten zur Fehlerbehandlung.
   Man koennte auch noch einen Zeiger auf eine Funktion uebergeben */
extern void /*@exits@*/ debug(const char *output);
  //__attribute__ ((__return__));
#define debug(data) debug_in((data), __FILE__, __LINE__)

extern void /*@exits@*/ debug_in(const char *output,
    const char *file, const int line);
  //__attribute__ ((__return__));

typedef enum {
  Minus = -1,
  Zero = 0,
  Plus = +1
} sign_t;

char *FixedDigitNumber(const int FragmentNumber, const int digits);
void performCriticalExit();
sign_t sign(double value);

/********************************************** helpful template functions *********************************/


/** Creates a lookup table for true father's Atom::Nr -> atom ptr.
 * \param *start begin of chain list
 * \paran *end end of chain list
 * \param **Lookuptable pointer to return allocated lookup table (should be NULL on start)
 * \param count optional predetermined size for table (otherwise we set the count to highest true father id)
 * \return true - success, false - failure
 */
template <typename T> bool CreateFatherLookupTable(T *start, T *end, T **&LookupTable, int count = 0)
{
  bool status = true;
  T *Walker = NULL;
  int AtomNo;

  if (LookupTable != NULL) {
    DoeLog(0) && (eLog() << Verbose(0) << "Pointer for Lookup table is not NULL! Aborting ..." <<endl);
    return false;
  }

  // count them
  if (count == 0) {
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::ParticleInfo_nr -> atom) used as a marker table lateron
      Walker = Walker->next;
      count = (count < Walker->GetTrueFather()->nr) ? Walker->GetTrueFather()->nr : count;
    }
  }
  if (count <= 0) {
    DoeLog(1) && (eLog() << Verbose(1) << "Count of lookup list is 0 or less." << endl);
    return false;
  }

  // allocate and fill
  LookupTable = new T*[count];
  if (LookupTable == NULL) {
    DoeLog(0) && (eLog()<< Verbose(0) << "LookupTable memory allocation failed!" << endl);
    performCriticalExit();
    status = false;
  } else {
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::ParticleInfo_nr -> atom) used as a marker table lateron
      Walker = Walker->next;
      AtomNo = Walker->GetTrueFather()->nr;
      if ((AtomNo >= 0) && (AtomNo < count)) {
        //*out << "Setting LookupTable[" << AtomNo << "] to " << *Walker << endl;
        LookupTable[AtomNo] = Walker;
      } else {
        DoeLog(2) && (eLog() << Verbose(2) << "Walker " << *Walker << " exceeded range of nuclear ids [0, " << count << ")." << endl);
        status = false;
        break;
      }
    }
  }

  return status;
};


#define PLURAL_S(v) (((v)==1)?"":"s")

// this is to allow different modes of access for
// maps and sets
template<typename Res,typename T>
struct _take{
  Res get(T value) const;
};

// if we have a set,vector etc we can directly access the result
template<typename Res>
struct _take<Res,Res>{
  static inline Res get(Res value){
    return value;
  }
};

// if we have a map we have to access the second part of
// the pair
template<typename Res,typename T1>
struct _take<Res,std::pair<T1,Res> >{
  static inline Res get(std::pair<T1,Res> value){
    return value.second;
  }
};

#endif /*HELPERS_HPP_*/
