/*
 * OperationQueueUnitTest.hpp
 *
 *  Created on: Apr 24, 2012
 *      Author: heber
 */

#ifndef OPERATIONQUEUEUNITTEST_HPP_
#define OPERATIONQUEUEUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/extensions/HelperMacros.h>

#include <boost/asio.hpp>

class AsyncOperation;
class Connection;
class OperationQueue;
class WorkerAddress;

/********************************************** Test classes **************************************/


class OperationQueueTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( OperationQueueTest) ;
    CPPUNIT_TEST ( push_backTest );
    CPPUNIT_TEST ( removeTest );
    CPPUNIT_TEST ( findTest );
    CPPUNIT_TEST ( observerTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void findTest();
      void push_backTest();
      void removeTest();
      void observerTest();

private:

      OperationQueue *queue;
      Connection *conn;
      AsyncOperation *op;
      AsyncOperation *otherop;
      boost::asio::io_service io_service;
      WorkerAddress *address;
};

#endif /* OPERATIONQUEUEUNITTEST_HPP_ */
