/*
 * MatrixContainer.hpp
 *
 *  Created on: Sep 15, 2011
 *      Author: heber
 */

#ifndef MATRIXCONTAINER_HPP_
#define MATRIXCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "boost/serialization/vector.hpp"

/** Contains a sequence of matrices parsed from file.
 *
 */
class MatrixContainer {
  public:
    typedef std::vector<std::vector<double> > MatrixArray;
    typedef std::vector<MatrixArray> ArrayOfMatrices;
    typedef std::vector<std::string> StringVector;
    typedef std::vector<int> IntVector;
    typedef std::vector<IntVector> VectorOfIntVectors;

    ArrayOfMatrices Matrix;
    VectorOfIntVectors Indices;
    StringVector Header;
    int MatrixCounter;
    IntVector RowCounter;
    IntVector ColumnCounter;

  MatrixContainer();
  virtual ~MatrixContainer();

  bool InitialiseIndices(class MatrixContainer *Matrix = NULL);
  bool ParseMatrix(std::istream &input, int skiplines, int skipcolumns, size_t MatrixNr);
  bool AddMatrix(const std::string &header, const MatrixArray &matrix, size_t MatrixNr);
  virtual bool ParseFragmentMatrix(const std::string name, const std::string prefix, std::string suffix, int skiplines, int skipcolumns);
  bool AllocateMatrix(StringVector GivenHeader, int MCounter, IntVector RCounter, IntVector CCounter);
  bool ResetMatrix();
  double FindMinValue();
  double FindMaxValue();
  bool SetLastMatrix(double value, int skipcolumns);
  bool SetLastMatrix(const MatrixArray &values, int skipcolumns);
  //bool ParseIndices();
  //bool SumSubValues();
  bool SumSubManyBodyTerms(class MatrixContainer &Matrix, class KeySetsContainer &KeySets, int Order);
  bool WriteTotalFragments(const std::string name, const std::string prefix);
  bool WriteLastMatrix(const std::string name, const std::string prefix, const std::string suffix);

  bool operator==(const MatrixContainer &other) const;

  bool operator!=(const MatrixContainer &other) const {
    return !(*this == other);
  }

private:
  friend class boost::serialization::access;
  // serialization
  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & Matrix;
    ar & Indices;
    ar & Header;
    ar & MatrixCounter;
    ar & RowCounter;
    ar & ColumnCounter;
  }
};

std::ostream & operator << (std::ostream &ost, const MatrixContainer &m);

#endif /* MATRIXCONTAINER_HPP_ */
