/*
 * QtQueryList.hpp
 *
 *  Created on: Jul 24, 2012
 *      Author: ankele
 */

#ifndef QTQUERYLIST_HPP_
#define QTQUERYLIST_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Dialog.hpp"
#include "Parameters/Parameter.hpp"
#include "Parameters/Validators/STLVectorValidator.hpp"
#include "Parameters/Validators/Ops_Validator_impl.hpp"

class QListWidget;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class QBoxLayout;

class QtQueryListUntyped {
public:
  QtQueryListUntyped(QBoxLayout *parent, Dialog *_dialog);
  virtual ~QtQueryListUntyped(){}

  virtual void onSubUpdate() = 0;

  void onUpdate();
  void elementSelected();
  void addElementToListWidget(const std::string &str);
  std::vector<int> getSelectedRows();
  void removeSelectedRows(const std::vector<int> &rows);

protected:
  QListWidget *inputList;
  QPushButton *addButton;
  QPushButton *removeButton;
  QVBoxLayout *thisVLayout;
  QHBoxLayout *thisHLayout;
  QVBoxLayout *buttonBox;
  Dialog *dialog;
};

template<class T>
class QtQueryList : public QtQueryListUntyped {
public:
  QtQueryList(Parameter<std::vector<T> > &parentParam, QBoxLayout *parent, Dialog *_dialog, std::vector<T> &_temp) : QtQueryListUntyped(parent, _dialog), tempRef(_temp)
  {
    // do we have an STLVectorValidator?
    Validator<std::vector<T> > *val = &parentParam.getValidator();
    STLVectorValidator<std::vector<T> > *vector_val = NULL;

    // might be hidden inside an And_Validator
    And_Validator<std::vector<T> > * and_val = dynamic_cast<And_Validator<std::vector<T> > *>(val);
    if (and_val){
      if (dynamic_cast<STLVectorValidator<std::vector<T> > *>(and_val->getA()))
        vector_val = dynamic_cast<STLVectorValidator<std::vector<T> > *>(and_val->getA());
      else if (dynamic_cast<STLVectorValidator<std::vector<T> > *>(and_val->getB()))
        vector_val = dynamic_cast<STLVectorValidator<std::vector<T> > *>(and_val->getB());
    }else{
      vector_val = dynamic_cast<STLVectorValidator<std::vector<T> > *>(val);
    }

    if (vector_val){
      // if so, try to use its ElementwiseValidator
      subParam = new Parameter<T>("sub-param", *(vector_val->getElementwiseValidator()));
    }else{
      subParam = new Parameter<T>("sub-param");
    }
  }
  virtual ~QtQueryList()
  {
    delete(subParam);
  }

  void addElement() {
    // add item to both
    addElementToListWidget(subParam->getAsString());
    tempRef.push_back(subParam->get());
    onUpdate();
  }
  void removeElements()
  {
    std::vector<int> rows = getSelectedRows();
    removeSelectedRows(rows);
    for (int i = rows.size() - 1; i >= 0; i --){
      ASSERT((size_t)(rows[i]) < tempRef.size(), "QtQueryList<T>::removeElements() trying to remove invalid element.");
      tempRef.erase(tempRef.begin() + rows[i]);
    }
    onUpdate();
  }
protected:
  std::vector<T> &tempRef;
  Parameter<T> *subParam;
};



class ListQuerySubDialog : public Dialog
{
public:
  ListQuerySubDialog(QtQueryListUntyped *_parent) : parent(_parent), sub(NULL){}
  virtual void update()
  {
    if (sub)
      if (sub->isValid())
        sub->setResult();
    parent->onSubUpdate();
  }
  void setSubQuery(Query *_sub){  sub = _sub; }

  virtual void queryEmpty(const std::string = "", const std::string = ""){}
  virtual void queryBoolean(Parameter<bool> &, const std::string = "", const std::string = ""){}
  virtual void queryInt(Parameter<int> &, const std::string = "", const std::string = ""){}
  virtual void queryInts(Parameter<std::vector<int> > &, const std::string = "", const std::string = ""){}
  virtual void queryUnsignedInt(Parameter<unsigned int> &, const std::string = "", const std::string = ""){}
  virtual void queryUnsignedInts(Parameter<std::vector<unsigned int> > &, const std::string = "", const std::string = ""){}
  virtual void queryDouble(Parameter<double> &, const std::string = "", const std::string = ""){}
  virtual void queryDoubles(Parameter<std::vector<double> > &, const std::string = "", const std::string = ""){}
  virtual void queryString(Parameter<std::string> &, const std::string = "", const std::string = ""){}
  virtual void queryStrings(Parameter<std::vector<std::string> > &, const std::string = "", const std::string = ""){}
  virtual void queryAtom(Parameter<const atom *> &, const std::string = "", const std::string = ""){}
  virtual void queryAtoms(Parameter<std::vector<const atom *> > &, const std::string = "", const std::string = ""){}
  virtual void queryMolecule(Parameter<const molecule *> &, const std::string = "", const std::string = ""){}
  virtual void queryMolecules(Parameter<std::vector<const molecule *> > &, const std::string = "", const std::string = ""){}
  virtual void queryVector(Parameter<Vector> &, const std::string = "", const std::string = ""){}
  virtual void queryVectors(Parameter<std::vector<Vector> > &, const std::string = "", const std::string = ""){}
  virtual void queryRealSpaceMatrix(Parameter<RealSpaceMatrix> &, const std::string = "", const std::string = ""){}
  virtual void queryElement(Parameter<const element *> &, const std::string = "", const std::string = ""){}
  virtual void queryElements(Parameter<std::vector<const element *> > &, const std::string = "", const std::string = ""){}
  virtual void queryFile(Parameter<boost::filesystem::path> &, const std::string = "", const std::string = ""){}
  virtual void queryFiles(Parameter<std::vector< boost::filesystem::path> > &, const std::string = "", const std::string = ""){}
  virtual void queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &, const std::string = "", const std::string = ""){}
private:
  QtQueryListUntyped *parent;
  Query *sub;
};


#endif /* QTQUERYLIST_HPP_ */
