/*
 * FragmentResult.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTRESULT_HPP_
#define FRAGMENTRESULT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

#include "boost/serialization/array.hpp"

#include "JobId.hpp"
#include "types.hpp"

class FragmentQueueTest;
class FragmentResultTest;

/** This class contains the result to a specific FragmentJob.
 *
 */
class FragmentResult : public JobId
{
  //!> allow FragmentQueue unit test access
  friend class FragmentQueueTest;
  //!> allow own unit test access
  friend class FragmentResultTest;
public:
  FragmentResult(const JobId_t id);
  FragmentResult(const JobId_t id, const std::string _result);
  FragmentResult(const FragmentResult &other);
  ~FragmentResult();

  FragmentResult& operator=(const FragmentResult &other);
  bool operator==(const FragmentResult &other) const;
  bool operator!=(const FragmentResult &other) const
    { return !(*this == other); }

  //!> result
  std::string result;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<JobId>(*this);
    ar & result;
  }
};


#endif /* FRAGMENTRESULT_HPP_ */
